/* 
 *  GUIUtil.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import java.util.List;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.Pair;

public class GUIUtil {

    public static VBox properties(List<Pair<String, String>> data) {
        VBox vbox = new VBox();
        vbox.getStyleClass().add("sideBar");

        GridPane grid = new GridPane();
        grid.getStyleClass().add("customerData");

        int row = 0;

        for (Pair<String, String> pair : data) {
            Text title = new Text(pair.getKey());
            title.getStyleClass().add("customerDataLabels");
            grid.add(title, 1, row);

            Text titleValue = new Text(pair.getValue());
            titleValue.setWrappingWidth(150);
            titleValue.getStyleClass().add("customerDataValues");
            grid.add(titleValue, 2, row);
            row++;
        }
        vbox.getChildren().add(grid);
        return vbox;
    }

    public static VBox capabilities(List<Pair<String, Boolean>> data) {
        VBox vbox = new VBox();
        vbox.getStyleClass().add("sideBar");

        GridPane grid = new GridPane();
        grid.getStyleClass().add("customerData");

        int row = 0;
        for (Pair<String, Boolean> pair : data) {
            Text title = new Text(pair.getKey());
            
            if (pair.getValue()) {
                title.getStyleClass().add("customerDataTrue");
            } else {
                title.getStyleClass().add("customerDataFalse");
            }

            grid.add(title, 1, row);
            row++;           
        }
        vbox.getChildren().add(grid);
        return vbox;
    }

}
